# binom_plot.R
# Plot probabilities for the binomial distribution

# Load necessary libraries
library(ggplot2)

# Binomial parameters here
l <- 10
p <- 0.1

# Binomial distribution function
y <- 0:l
proby <- dbinom(y,l,p)

# Make data frame for ggplot2
bindata <- as.data.frame(cbind(y,proby))

# Print data
bindata

# Generate plot showing frequencies
ggplot(bindata,aes(y,proby))+
geom_bar(stat="identity",width=0.05,fill="red")+
geom_point(color="red",size=3)+
ggtitle("Binomial distribution, l = 10 and p = 0.5")
